// get the client
const mysql = require('mysql');
require('./../constants/ApplicationConstants.js')();

var connection  = mysql.createPool({
  host     : getprimaryhost(),
  user     : getprimaryuser(),
  password : getprimarypassword(),
  database : getprimarydatabase(),
  debug : false,
  connectionLimit : 20,
  connectTimeout  : 10 * 60 * 1000,
  acquireTimeout  : 10 * 60 * 1000,
  timeout         : 10 * 60 * 1000
});


//- Reconnection function
function reconnect(connection){
    console.log("\n New connection tentative...");

    //- Destroy the current connection variable
    if(connection) connection.destroy();

    //- Create a new one
    var connection_temp = mysql.createPool({
                                host     : getprimaryhost(),
                                user     : getprimaryuser(),
                                password : getprimarypassword(),
                                database : getprimarydatabase(),
                                debug : false,
                                connectionLimit : 20,
                                connectTimeout  : 10 * 60 * 1000,
                                acquireTimeout  : 10 * 60 * 1000,
                                timeout         : 10 * 60 * 1000
                              })

    //- Try to reconnect
    connection_temp.connect(function(err){
        if(err) {
            //- Try to connect every 2 seconds.
            setTimeout(reconnect, 200);
        }else {
            console.log("\n\t *** New connection established with the database. ***")
            return connection_temp;
        }
    });
}

//- Error listener
connection.on('error', function(err) {

    //- The server close the connection.
    if(err.code === "PROTOCOL_CONNECTION_LOST"){    
        console.log("/!\\ Cannot establish a connection with the database. /!\\ ("+err.code+")");
        connection = reconnect(connection);
    }

    //- Connection in closing
    else if(err.code === "PROTOCOL_ENQUEUE_AFTER_QUIT"){
        console.log("/!\\ Cannot establish a connection with the database. /!\\ ("+err.code+")");
        connection = reconnect(connection);
    }

    //- Fatal error : connection variable must be recreated
    else if(err.code === "PROTOCOL_ENQUEUE_AFTER_FATAL_ERROR"){
        console.log("/!\\ Cannot establish a connection with the database. /!\\ ("+err.code+")");
        connection = reconnect(connection);
    }

    //- Error because a connection is already being established
    else if(err.code === "PROTOCOL_ENQUEUE_HANDSHAKE_TWICE"){
        console.log("/!\\ Cannot establish a connection with the database. /!\\ ("+err.code+")");
    }

    //- Anything else
    else{
        console.log("/!\\ Cannot establish a connection with the database. /!\\ ("+err.code+")");
        connection = reconnect(connection);
    }

});
module.exports = connection;

