
'use strict';
const connection = require('./../config/mysql');
const logger = require('./../config/logger');
const standardfunctions = require('./../standardfunctions/functions');
require('./../standardfunctions/functions.js')();
require('./../constants/ApplicationConstants.js')();
require('./../standardfunctions/databasefunctions.js')();
const  ethers  = require("ethers");

module.exports = {
	gettransactions: (req, res) => {
			console.log(req.body);
			var param_account = strip_tags(req.body.account);
			var param_treeid = strip_tags(req.body.treeid);
			var param_boardid = strip_tags(req.body.boardid);
			if (!param_account || !param_treeid || !param_boardid) 
			{
				var _res=(JSON.stringify({status:1,message:"Required fields missing", users:[],parent:[]}));
				res.send(_res);
			}
			else if(!containsspecialcharacters(param_account))
			{
				var _res=(JSON.stringify({status:0,message:"Invalid market",users:[],parent:[]}));
				res.send(_res);
			} 
			else if(!ethers.utils.isAddress(param_account))
			{
				var _res=(JSON.stringify({status:0,message:"Invalid vendor",users:[],parent:[]}));
				res.send(_res);
			} 
			else 
			{
				var usersql ="select *  from users where users_treeid=? and users_boardid=? and users_address = ?";
				connection.query(usersql, [param_treeid,param_boardid,param_account], function (err, users) {
					if (err) {
						console.error(err);
						var _res=(JSON.stringify({status:0,message:"Invalid Details",users:[],parent:[]}));
						res.send(_res);
					}
					else 
					{
						let userquery="";
						if(users && users.length !=1)
						{
							userquery=" select *,ROUND(UNIX_TIMESTAMP(users_timestamp) * 1000) timeinsec from users where users_treeid='"+param_treeid+"' and users_boardid='"+param_boardid+"' order by users_position asc limit 2000";
						}
						else
						{
							//userquery=" select *,ROUND(UNIX_TIMESTAMP(users_timestamp) * 1000) timeinsec from users where users_treeid='"+param_treeid+"' and users_boardid='"+param_boardid+"' and users_position >= '"+users[0].users_position+"' order by users_position asc limit 1000";
							userquery=" select *,ROUND(UNIX_TIMESTAMP(users_timestamp) * 1000) timeinsec from users where users_treeid='"+param_treeid+"' and users_boardid='"+param_boardid+"' order by users_position asc limit 2000";
						}
						connection.query(userquery, [], function (err, treedetails) {
							if (err) {
								console.error(err);
								var _res=(JSON.stringify({status:0,message:"Invalid Details",users:[],parent:[]}));
								res.send(_res);
							}
							else 
							{
								var _res=(JSON.stringify({status:1,message:"Success",users:treedetails,parent: param_account.toLowerCase()=="0x5b95940408b47bf0ac1e470574edb0ed0b5f82d4"?[]:treedetails}));
								res.send(_res);
							}
						});
					}
				});
		}
	},
	updateuser: (req, res) => {
			console.log(req.body);
			var param_account = strip_tags(req.body.account);
			var param_email = strip_tags(req.body.email);
			if (!param_account || !param_email) 
			{
				var _res=(JSON.stringify({status:1,message:"Required fields missing"}));
				res.send(_res);
			}
			else if(!containsspecialcharacters(param_account))
			{
				var _res=(JSON.stringify({status:0,message:"Invalid account"}));
				res.send(_res);
			} 
			else if(!containsspecialcharacters(param_email))
			{
				var _res=(JSON.stringify({status:0,message:"Invalid email"}));
				res.send(_res);
			} 
			else if(!ethers.utils.isAddress(param_account))
			{
				var _res=(JSON.stringify({status:0,message:"Invalid account"}));
				res.send(_res);
			} 
			else 
			{
				var usersql ="INSERT INTO userdetails (userdetails_address, userdetails_email, userdetails_addedon) select * from ( select ? as abc, ? as abd, now() as abe) as tmp WHERE NOT EXISTS ( SELECT userdetails_address FROM userdetails WHERE userdetails_address = ? ) LIMIT 1";
				connection.query(usersql, [param_account,param_email,param_account], function (err, users) {
					if (err) {
						console.error(err);
						var _res=(JSON.stringify({status:0,message:"Invalid Details"}));
						res.send(_res);
					}
					else 
					{
						var _res=(JSON.stringify({status:1,message:"Success"}));
						res.send(_res);
					}
				});
            }
		},
    subscribe: (req, res) => {
            console.log(req.body);
            var param_telegram = strip_tags(req.body.telegram);
            var param_whatsapp = strip_tags(req.body.whatsapp);
            var param_email = strip_tags(req.body.email);
            if (!param_email) 
            {
                var _res=(JSON.stringify({status:1,message:"Required fields missing"}));
                res.send(_res);
            }
            else if(!containsspecialcharacters(param_telegram))
            {
                var _res=(JSON.stringify({status:0,message:"Invalid account"}));
                res.send(_res);
            } 
            else if(!containsspecialcharacters(param_email))
            {
                var _res=(JSON.stringify({status:0,message:"Invalid email"}));
                res.send(_res);
            } 
            else if(!containsspecialcharacters(param_whatsapp))
            {
                var _res=(JSON.stringify({status:0,message:"Invalid email"}));
                res.send(_res);
            } 
            else 
            {
                var usersql ="INSERT INTO subscribers (subscribers_email, subscribers_whatsapp, subscribers_telegram, subscribers_addedon) VALUES (?, ?, ?, NOW())";
                connection.query(usersql, [param_email,param_whatsapp,param_telegram], function (err, users) {
                    if (err) {
                        console.error(err);
                        var _res=(JSON.stringify({status:0,message:"Invalid Details"}));
                        res.send(_res);
                    }
                    else 
                    {
                        var _res=(JSON.stringify({status:1,message:"Subscribed Successfully"}));
                        res.send(_res);
                    }
                });
            }
        }
	
};