
'use strict';
const connection = require('./../config/mysql');
const logger = require('./../config/logger');
const standardfunctions = require('./../standardfunctions/functions');
require('./../standardfunctions/functions.js')();
require('./../constants/ApplicationConstants.js')();
require('./../standardfunctions/databasefunctions.js')();
const ethers = require("ethers");

module.exports = {
	gettransactions: (req, res) => {
		console.log(req.body);
		var param_account = strip_tags(req.body.account);
		var param_treeid = strip_tags(req.body.treeid);
		var param_boardid = strip_tags(req.body.boardid);
		if (!param_account || !param_treeid || !param_boardid) {
			var _res = (JSON.stringify({ status: 1, message: "Required fields missing", users: [], parent: [] }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(param_account)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid market", users: [], parent: [] }));
			res.send(_res);
		}
		else if (!ethers.utils.isAddress(param_account)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid vendor", users: [], parent: [] }));
			res.send(_res);
		}
		else {
			var usersql = "select *,ROUND(UNIX_TIMESTAMP(users_timestamp) * 1000) timeinsec  from users where users_treeid=? and users_boardid=? ";
			connection.query(usersql, [param_treeid, param_boardid], function (err, users) {
				if (err) {
					console.error(err);
					var _res = (JSON.stringify({ status: 0, message: "Invalid Details", users: [], parent: [] }));
					res.send(_res);
				}
				else {
					let userlist = [];
					let _users = [...users.sort(function (a, b) {
						return a.timeinsec - b.timeinsec;
					})];
					let ifexists = _users.find(o => o.users_address.toLowerCase() == param_account.toLowerCase());
					if (ifexists != null) {
						userlist.push(ifexists);
					}
					else {
						userlist.push(_users[0]);
					}
					for (let loopvar = 0; loopvar < _users.length; loopvar++) {
						if (userlist.find(o => o.users_address.toLowerCase() == _users[loopvar].users_parents.toLowerCase()) != null) {
							userlist.push(_users[loopvar]);
							//console.log("inside",userlist);
						}
						else {
							//console.log(_sorteduser[loopvar].users_parents, _sorteduser[loopvar].users_parents , userlist);
						}
					}
					console.log(userlist);
					let parentlist=[];
					
					let _admins = [...users.sort(function (a, b) {
						return a.timeinsec - b.timeinsec;
					})];

					let _main=userlist[0];
					console.log(_main, _admins.find(o => o.users_address.toLowerCase() == _main.users_parents.toLowerCase()));
					if(_admins.find(o => o.users_address.toLowerCase() == _main.users_parents.toLowerCase()) != null)
					{
						let _a=_admins.find(o => o.users_address.toLowerCase() == _main.users_parents.toLowerCase());
						if(_admins.find(o => o.users_address.toLowerCase() == _a.users_parents.toLowerCase()) != null)
						{
							let _b=_admins.find(o => o.users_address.toLowerCase() == _a.users_parents.toLowerCase());
							//console.log(_b);
							if(_admins.find(o => o.users_address.toLowerCase() == _b.users_parents.toLowerCase()) != null)
							{
								let _c=_admins.find(o => o.users_address.toLowerCase() == _b.users_parents.toLowerCase());
								parentlist.push(_c);
								
								//console.log(parentlist);
							}
							else
							{
								parentlist.push(_b);
							}
						}
						else
						{
							parentlist.push(_a);
						}
						for (let loopvar = 0; loopvar < _admins.length; loopvar++) {
							if (parentlist.find(o => o.users_address.toLowerCase() == _admins[loopvar].users_parents.toLowerCase()) != null) {
								parentlist.push(_admins[loopvar]);
								//console.log("inside",userlist);
							}
							else {
								//console.log(_sorteduser[loopvar].users_parents, _sorteduser[loopvar].users_parents , userlist);
							}
						}
					}
					var _res = (JSON.stringify({ status: 1, message: "Success", users: userlist, parent: parentlist }));
					res.send(_res);

				}
			});
		}
	},
	updateuser: (req, res) => {
		console.log(req.body);
		var param_account = strip_tags(req.body.account);
		var param_email = strip_tags(req.body.email);
		if (!param_account || !param_email) {
			var _res = (JSON.stringify({ status: 1, message: "Required fields missing" }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(param_account)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid account" }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(param_email)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid email" }));
			res.send(_res);
		}
		else if (!ethers.utils.isAddress(param_account)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid account" }));
			res.send(_res);
		}
		else {
			var usersql = "INSERT INTO userdetails (userdetails_address, userdetails_email, userdetails_addedon) select * from ( select ? as abc, ? as abd, now() as abe) as tmp WHERE NOT EXISTS ( SELECT userdetails_address FROM userdetails WHERE userdetails_address = ? ) LIMIT 1";
			connection.query(usersql, [param_account, param_email, param_account], function (err, users) {
				if (err) {
					console.error(err);
					var _res = (JSON.stringify({ status: 0, message: "Invalid Details" }));
					res.send(_res);
				}
				else {
					var _res = (JSON.stringify({ status: 1, message: "Success" }));
					res.send(_res);
				}
			});
		}
	},
	subscribe: (req, res) => {
		console.log(req.body);
		var param_telegram = strip_tags(req.body.telegram);
		var param_whatsapp = strip_tags(req.body.whatsapp);
		var param_email = strip_tags(req.body.email);
		if (!param_email) {
			var _res = (JSON.stringify({ status: 1, message: "Required fields missing" }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(param_telegram)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid account" }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(param_email)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid email" }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(param_whatsapp)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid email" }));
			res.send(_res);
		}
		else {
			var usersql = "INSERT INTO subscribers (subscribers_email, subscribers_whatsapp, subscribers_telegram, subscribers_addedon) VALUES (?, ?, ?, NOW())";
			connection.query(usersql, [param_email, param_whatsapp, param_telegram], function (err, users) {
				if (err) {
					console.error(err);
					var _res = (JSON.stringify({ status: 0, message: "Invalid Details" }));
					res.send(_res);
				}
				else {
					var _res = (JSON.stringify({ status: 1, message: "Subscribed Successfully" }));
					res.send(_res);
				}
			});
		}
	}

};