
'use strict';
const connection = require('./../config/mysql');
const logger = require('./../config/logger');
const standardfunctions = require('./../standardfunctions/functions');
require('./../standardfunctions/functions.js')();
require('./../constants/ApplicationConstants.js')();
require('./../standardfunctions/databasefunctions.js')();
const ethers = require("ethers");

module.exports = {
	getnews: (req, res) => {
			var usersql = "select * from news order by news_id desc ";
			connection.query(usersql, [], function (err, news) {
				if (err) {
					console.error(err);
					var _res = (JSON.stringify({ status: 0, message: "Invalid Details", news: [] }));
					res.send(_res);
				}
				else {
					var _res = (JSON.stringify({ status: 1, message: "Success", news: news }));
					res.send(_res);
				}
			});
	},
	getnewsDetails: (req, res) => {
		console.log(req.body);
		var id = strip_tags(req.body.id);
		if (!id) {
			var _res = (JSON.stringify({ status: 1, message: "Required fields missing" }));
			res.send(_res);
		}
		else if (!containsspecialcharacters(id)) {
			var _res = (JSON.stringify({ status: 0, message: "Invalid account" }));
			res.send(_res);
		}
		else {
			var usersql = "select * from news where news_id=? order by news_id desc ";
			connection.query(usersql, [Number(id)], function (err, news) {
				if (err) {
					console.error(err);
					var _res = (JSON.stringify({ status: 0, message: "Invalid Details", news: [] }));
					res.send(_res);
				}
				else {
					var usersql = "select * from news where news_id != ? order by RAND() limit 0,4";
					connection.query(usersql, [Number(id)], function (err, related) {
						if(err)
						{
							var _res = (JSON.stringify({ status: 1, message: "Success", news: news,related:[] }));
							res.send(_res);
						}
						else
						{
							var _res = (JSON.stringify({ status: 1, message: "Success", news: news,related:related }));
							res.send(_res);
						}
					});
				}
			});
		}
	}

};